//Source file: H:\middleware\src\Alkindi\BusinessDataTypes\UserRatings.java

package Alkindi.Services.InternalData;

import Alkindi.Data.*;
import java.util.Iterator;

/* 
$Header: UserRatings.java, 20, 4/26/01 2:37:00 PM, Schwartz, Joe$
$Log: 
 20   Alkindi Development1.19        4/26/01 2:37:00 PM   Schwartz, Joe  
      Modifed to account for movement to new packages.
 19   Alkindi Development1.18        4/26/01 1:46:08 PM   Schwartz, Joe   Moved
      to new package.
 18   Alkindi Development1.17        2/14/01 6:20:58 PM   Schwartz, Joe  
      Removed distance functions (base class will suffice).
 17   Alkindi Development1.16        2/13/01 5:54:46 PM   Schwartz, Joe  
      Changed to account for new SparseRatingsArray class, used for base class
      of RatingSpacePoint.
 16   Alkindi Development1.15        1/26/01 5:48:31 PM   Schwartz, Joe  
      Improving efficiency.
 15   Alkindi Development1.14        1/23/01 1:45:47 PM   Schwartz, Joe  
      Modified to work with floats instead of doubles.
 14   Alkindi Development1.13        1/22/01 1:46:13 PM   Schwartz, Joe  
      Converted into subclass of RatingSpacePoint.
 13   Alkindi Development1.12        12/28/00 1:07:28 PM  Schwartz, Joe   Added
      Version Control header info.
 12   Alkindi Development1.11        12/26/00 6:57:17 PM  Schwartz, Joe   
 11   Alkindi Development1.10        12/18/00 12:06:26 PM Schwartz, Joe   Moved
      from (public) BusinessDataTypes package.
 10   Alkindi Development1.9         12/15/00 6:17:41 PM  Schwartz, Joe  
      Changed internal storage to HashMap. 
 9    Alkindi Development1.8         12/5/00 1:21:19 PM   Schwartz, Joe   
 8    Alkindi Development1.7         12/3/00 7:51:19 PM   Schwartz, Joe   
 7    Alkindi Development1.6         12/3/00 5:28:01 PM   Schwartz, Joe   
 6    Alkindi Development1.5         12/2/00 1:01:54 PM   Schwartz, Joe   
 5    Alkindi Development1.4         12/1/00 9:48:51 PM   Schwartz, Joe   
 4    Alkindi Development1.3         10/22/00 2:58:57 PM  Schwartz, Joe  
      Changed package to BeanImpl.
 3    Alkindi Development1.2         10/22/00 10:38:48 AM Schwartz, Joe  
      AppianDelivery 10.20.00
 2    Alkindi Development1.1         10/17/00 2:16:36 PM  Schwartz, Joe  
      Delivery 10.16.00
 1    Alkindi Development1.0         10/7/00 4:26:03 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * This is a list of a single User's Ratings. It extends the class RatingSpacePoint to include a reference to the SystemUser for whom ratings are collected.
 */
public class UserRatings extends RatingSpacePoint 
{
	
	/**
	 * The user with whom all the listed ratings are associated.
	 */
	private SystemUser theUser;
	
	/**
	 * Returns the user for whom the ratings are stored.
	 * @return SystemUser
	 * @roseuid 3A284438005D
	 */
	public SystemUser user() 
	{
		return theUser;
	}
	
	/**
	 * Creates a new UserRatings object for the given SystemUser
	 * @roseuid 3A284EDE0128
	 */
	public UserRatings(SystemUser forUser) 
	{
		theUser = forUser;
	}
}
